

#include "tomcrypt.h"

/**
   Provide the correct sizes of the working states (contexts).
   Needed so pyTomCrypt.py can allocate the right amount of 
   memory instead of some arbitrarily large size.
   
   Larry Bugbee
   December 2006
   rev January 2007
   rev June 2007
*/


void init_LTM();
void init_TFM();

int hash_state_size();
int prng_state_size();

int hmac_state_size();
int omac_state_size();
int pmac_state_size();
int pelican_state_size();
int xcbc_state_size();
int f9_state_size();

int symmetric_ECB_size();
int symmetric_CBC_size();
int symmetric_CTR_size();
int symmetric_CFB_size();
int symmetric_OFB_size();
int symmetric_LRW_size();
int symmetric_F8_size();

int rsa_key_size();
int ecc_key_size();
int dsa_key_size();


/**************************************************************/
/**************************************************************/
/**************************************************************/

/*    for the moment, unused...

** hashing algorithms **

int sha512_state_size();
int sha256_state_size();
int sha1_state_size();
int md5_state_size();
int md4_state_size();
int tiger_state_size();
int md2_state_size();
int rmd128_state_size();
int rmd160_state_size();
int rmd256_state_size();
int rmd320_state_size();
int whirlpool_state_size();
int chc_state_size();

** cipher algorithms **

int blowfish_key_size();
int rc5_key_size();
int rc6_key_size();
int saferp_key_size();
int rijndael_key_size();
int kseed_key_size();
int kasumi_key_size();
int xtea_key_size();
int twofish_key_size();
int safer_key_size();
int rc2_key_size();
int des_key_size();
int des3_key_size();
int cast5_key_size();
int noekeon_key_size();
int skipjack_key_size();
int khazad_key_size();
int anubis_key_size();

** prng algorithms **

int yarrow_prng_size();
int rc4_prng_size();
int fortuna_prng_size();
int sober128_prng_size();

*/
