

#include "tomcrypt_plus.h"

/**
   Provide the correct sizes of the working states (contexts).
   Needed so pyTomCrypt.py can allocate the right amount of 
   memory instead of some arbitrarily large size.
   
   Larry Bugbee
   December 2006
   rev January 2007
*/

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* expose some named constants 
 */

int PUBLIC_KEY()  { return PK_PUBLIC;  }
int PRIVATE_KEY() { return PK_PRIVATE; }

/* for the next three, see tomcrypt_pkcs.h */
int PKCS_1_V1_5() { return LTC_LTC_PKCS_1_V1_5; }
int PKCS_1_OAEP() { return LTC_LTC_PKCS_1_OAEP; }
int PKCS_1_PSS()  { return LTC_LTC_PKCS_1_PSS;  }

int COUNTER_LITTLE_ENDIAN() { return CTR_COUNTER_LITTLE_ENDIAN; }
int COUNTER_BIG_ENDIAN()    { return CTR_COUNTER_BIG_ENDIAN; }
int CTR_RFC3686()           { return LTC_CTR_RFC3686; }


/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* init math libs 
 */

#ifdef USE_LTM
void init_LTM() {
    ltc_mp = ltm_desc;
}
#endif

#ifdef USE_TFM
void init_TFM() {
    ltc_mp = tfm_desc;
}
#endif

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* unioned state sizes 
 */
int hash_state_size() {
   return sizeof(hash_state);
}

int prng_state_size() {
   return sizeof(prng_state);
}


/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* MAC sizes 
 */
int hmac_state_size() {
   return sizeof(hmac_state);
}

int omac_state_size() {
   return sizeof(omac_state);
}

int pmac_state_size() {
   return sizeof(pmac_state);
}

int pelican_state_size() {
   return sizeof(pelican_state);
}

int xcbc_state_size() {
   return sizeof(xcbc_state);
}

int f9_state_size() {
   return sizeof(f9_state);
}


/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* mode sizes 
 */

int symmetric_ECB_size() {
   return sizeof(symmetric_ECB);
}

int symmetric_CBC_size() {
   return sizeof(symmetric_CBC);
}

int symmetric_CTR_size() {
   return sizeof(symmetric_CTR);
}

int symmetric_CFB_size() {
   return sizeof(symmetric_CFB);
}

int symmetric_OFB_size() {
   return sizeof(symmetric_OFB);
}

int symmetric_LRW_size() {
   return sizeof(symmetric_LRW);
}

int symmetric_F8_size() {
   return sizeof(symmetric_F8);
}


/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* key sizes 
 */

/* This will return the size of the DER encoding of a
   PUBLIC_KEY or PRIVATE_KEY depending on type
 */
int rsa_key_size() {
   return CRYPT_ERROR;          // not yet implemented
}

int ecc_key_size() {
   return CRYPT_ERROR;          // not yet implemented
}

int dsa_key_size() {
   return CRYPT_ERROR;          // not yet implemented
;
}


/**************************************************************/
/**************************************************************/
/**************************************************************/

/*       unused.    perhaps not needed?


int sha512_state_size() {
   return sizeof(struct sha512_state);
}

int sha256_state_size() {
   return sizeof(struct sha256_state);
}

int sha1_state_size() {
   return sizeof(struct sha1_state);
}

int md5_state_size() {
   return sizeof(struct md5_state);
}

int md4_state_size() {
   return sizeof(struct md4_state);
}

int tiger_state_size() {
   return sizeof(struct tiger_state);
}

int md2_state_size() {
   return sizeof(struct md2_state);
}

int rmd128_state_size() {
   return sizeof(struct rmd128_state);
}

int rmd160_state_size() {
   return sizeof(struct rmd160_state);
}

int rmd256_state_size() {
   return sizeof(struct rmd256_state);
}

int rmd320_state_size() {
   return sizeof(struct rmd320_state);
}

int whirlpool_state_size() {
   return sizeof(struct whirlpool_state);
}

int chc_state_size() {
   return sizeof(struct chc_state);
}



int blowfish_key_size() {
   return sizeof(struct blowfish_key);
}

int rc5_key_size() {
   return sizeof(struct rc5_key);
}

int rc6_key_size() {
   return sizeof(struct rc6_key);
}

int saferp_key_size() {
   return sizeof(struct saferp_key);
}

int rijndael_key_size() {
   return sizeof(struct rijndael_key);
}

int kseed_key_size() {
   return sizeof(struct kseed_key);
}

int kasumi_key_size() {
   return sizeof(struct kasumi_key);
}

int xtea_key_size() {
   return sizeof(struct xtea_key);
}

int twofish_key_size() {
   return sizeof(struct twofish_key);
}

int safer_key_size() {
   return sizeof(struct safer_key);
}

int rc2_key_size() {
   return sizeof(struct rc2_key);
}

int des_key_size() {
   return sizeof(struct des_key);
}

int des3_key_size() {
   return sizeof(struct des3_key);
}

int cast5_key_size() {
   return sizeof(struct cast5_key);
}

int noekeon_key_size() {
   return sizeof(struct noekeon_key);
}

int skipjack_key_size() {
   return sizeof(struct skipjack_key);
}

int khazad_key_size() {
   return sizeof(struct khazad_key);
}

int anubis_key_size() {
   return sizeof(struct anubis_key);
}





int yarrow_prng_size() {
   return sizeof(struct yarrow_prng);
}

int rc4_prng_size() {
   return sizeof(struct rc4_prng);
}

int fortuna_prng_size() {
   return sizeof(struct fortuna_prng);
}

int sober128_prng_size() {
   return sizeof(struct sober128_prng);
}

# sprng has no state ???


-----------------------------------------------  */

