
"""

    test-vector-hmac.py
    
    
    Larry Bugbee
    February 2007
    
"""

from pyTomCrypt import *
import sys, time

# alter next line so it points to the notes dir in libtomcrypt-1.xx
PATH = '../../../libtomcrypt-1.17/notes/'

def savetofile(filename, content):
    f = open(filename, 'wb')
    f.write(content)
    f.close()
    
def loadfmfile(filename):
    f = open(filename, 'rb')
    content = f.read()
    f.close()
    return content

#-----------------------------------------------------------------------------

if 0:
    msg = 'Kilroy was here!  ...and there.'
    key8   = 'keyvalue'
    key16  = 'keyvalue90123456'
    keyany = 'Now is the time for all good men...'
    
    hmac = HMAC('md5', keyany)
    hmac.process(msg)
    sig = hmac.done()
    print hmac.name
    print ' ', byt2hex(sig)
    
    hmac = HMAC('whirlpool', keyany)
    hmac.process(msg)
    sig = hmac.done()
    print hmac.name
    print ' ', byt2hex(sig)
    
    omac = OMAC('twofish', key16)
    omac.process(msg)
    sig = omac.done()
    print omac.name
    print ' ', byt2hex(sig)
    
    print 'A quick OMAC(twofish) signature...'
    print ' ', byt2hex(OMAC('twofish', key16).done(msg))
    
    omac = OMAC('des', key8)
    omac.process(msg)
    sig = omac.done()
    print omac.name
    print ' ', byt2hex(sig)
    
    pmac = PMAC('twofish', key16)
    pmac.process(msg)
    sig = pmac.done()
    print pmac.name
    print ' ', byt2hex(sig)
    
    pmac = Pelican(key16)
    pmac.process(msg)
    sig = pmac.done()
    print pmac.name
    print ' ', byt2hex(sig)
    
    xcbc = XCBC('twofish', key16)
    xcbc.process(msg)
    sig = xcbc.done()
    print xcbc.name
    print ' ', byt2hex(sig)
    
    f9 = F9('aes', key16)
    msg2 = msg+chr(0x40)
    pads = str(chr(0x00)*(16-(len(msg)+1)%16))
    if len(pads) != 16:
        msg2 += pads
    f9.process(msg2)
    sig = f9.done()
    print f9.name
    print ' ', byt2hex(sig)

#-----------------------------------------------------------------------------

if 1:
    problems = 0
    TVs = {}
    
    def build_hmac_tv(filename):
        line = ''
        
        f = open(filename)
        for line in f:
            line = line[:-1]
            if not line: continue
            parts = line.split()
            if len(parts) == 1:
                key = parts[0]
                TVs[key] = []
            if len(parts) == 2 and parts[0][-1] == ':':
                TVs[key].append(parts[1])
    
    def showlist(values):
        for v in values:
            print '   ', v
    
    def showTVs():
        for key,values in TVs.items():
            print
            print ' ', key, len(values)
            showlist(values)
    
    def nnstr(nn):
        s = ''
        for i in range(nn):
            s += chr(i)
        return s
    
    
    build_hmac_tv(PATH + 'hmac_tv.txt')
#    showTVs()
    
    algs = ['md5', 'sha1', 'sha224', 'whirlpool']
    
    for alg in algs:
        values = TVs['HMAC-'+alg]
        
#        print
#        print ' ', alg, len(values)
#        showlist(values)
        
        for nn in range(1,len(values)):
            msg = nnstr(nn)        
            key = hex2byt(values[nn-1])
            
            hmac = HMAC(alg, key)
            hmac.process(msg)
            sig = hmac.done()
            
            if sig != hex2byt(values[nn]):
                print '  *** %s problem with vector %d' % (alg, nn)
                problems += 1
    #        if nn == 5: break
        
    if not problems:
        print
        print '  *** no HMAC problems detected with', str(algs)
        print
    

#-----------------------------------------------------------------------------
#-----------------------------------------------------------------------------
#-----------------------------------------------------------------------------

