#!/usr/bin/env python

"""
    demo-hash1.py
    
    This program is an elementary demonstration of various 
    algorithms implemented in TomLibCrypt. 
    
    pyTomCrypt is experimental software and intended for 
    educational purposes only.  To make your learning and 
    experimentation less cumbersome, pyTomCrypt is placed 
    in the Public Domain.
    
    Enjoy,
      
    Larry Bugbee
    bugbee@seanet.com
    March 6, 2007

"""


from pyTomCrypt import *

#---------------------------------------------------------------
# definitions
message = 'abc'

#---------------------------------------------------------------
# utility functions
def savetofile(filename, content):
    f = open(filename, 'wb')
    f.write(content)
    f.close()
    
def loadfmfile(filename):
    f = open(filename, 'rb')
    content = f.read()
    f.close()
    return content

def byt2hex(bs):
    "convert a byte string to hex"
    h = ''
    for c in bs:
        h += ('0'+hex(ord(c))[2:])[-2:]
    return h

#---------------------------------------------------------------
# list supported hashing algorithms
supported = get_supported_hashes()
print '  Supported hash algorithms:'
for alg in supported:
    print '    %s' % alg
print

#---------------------------------------------------------------
# create a few digests
message = 'abc'
print '  message  ', message

alg = 'md5'
md = md5()
md.update(message)
digest = md.final()
print '    %-9s  %s' % (alg, byt2hex(digest))

alg = 'sha1'
md = sha1()
md.update(message)
digest = md.final()
print '    %-9s  %s' % (alg, byt2hex(digest))

alg = 'tiger'
md = tiger()
md.update(message)
digest = md.final()
print '    %-9s  %s' % (alg, byt2hex(digest))

message = 'Kilroy was here ...and there.'
print '  message  ', message

alg = 'tiger'
md = tiger()
md.update(message)
digest = md.final()
print '    %-9s  %s' % (alg, byt2hex(digest))

#---------------------------------------------------------------
# should the message be long...
message = 'Kilroy was here ...and there.'
print '  message  ', message

alg = 'tiger'
md = tiger()
md.update(message[:20])     # 1st 20 chars
md.update(message[20:])     # all remaining chars
digest = md.final()
print '    %-9s  %s' % (alg, byt2hex(digest))

alg = 'rmd128'          # RIPEMD-128
md = rmd128()
md.update(message[:20])
md.update(message[20:])
digest = md.final()
print '    %-9s  %s' % (alg, byt2hex(digest))


#---------------------------------------------------------------
#---------------------------------------------------------------
#---------------------------------------------------------------

