#!/usr/bin/env python

"""
    demo-ecdsa1.py
    
    This program is an elementary demonstration of digital 
    signatures using LibTomCrypt.  The hashing algorithm is 
    SHA-1 and the key pair's underlying elliptical curve is 
    secp160r1. 
    
    pyTomCrypt is experimental software and intended for 
    educational purposes only.  To make your learning and 
    experimentation less cumbersome, pyTomCrypt is placed 
    in the Public Domain.
    
    Enjoy,
      
    Larry Bugbee
    bugbee@seanet.com
    March 6, 2007

"""


from pyTomCrypt import *

#---------------------------------------------------------------
# definitions
pvtkeyfilename = 'test_ecc_pvtkey.der'
pubkeyfilename = 'test_ecc_pubkey.der'

#---------------------------------------------------------------
# utility functions
def savetofile(filename, content):
    f = open(filename, 'wb')
    f.write(content)
    f.close()
    
def loadfmfile(filename):
    f = open(filename, 'rb')
    content = f.read()
    f.close()
    return content

def byt2hex(bs):
    "convert a byte string to hex"
    h = ''
    for c in bs:
        h += ('0'+hex(ord(c))[2:])[-2:]
    return h

#---------------------------------------------------------------
# make a key pair, save pvt key
ec = ECC_Context()
ec.make_key(160)        # NIST curve P-160, aka secp160r1
pvtkey = ec.get_private_key()
savetofile(pvtkeyfilename, pvtkey)

#---------------------------------------------------------------
# make public key available to whomever
pubkey = ec.get_public_key()
savetofile(pubkeyfilename, pubkey)

#---------------------------------------------------------------
# create a message and digest
message = 'Kilroy was here ...and there.'
md = sha1()
md.update(message)
digest = md.final()
print '  message  ', message
print '  digest   ', byt2hex(digest)

#---------------------------------------------------------------
# sign the message
signer = ECC_Context()
pvtkey = loadfmfile(pvtkeyfilename)
signer.load_key(pvtkey)
signature = signer.sign(digest)
# NB: signature should be different value each time
print '  signature', byt2hex(signature)

#---------------------------------------------------------------
# hypothetically send message and signature to relying party

#---------------------------------------------------------------
# verify integrity of message
verifier = ECC_Context()
pubkey = loadfmfile(pubkeyfilename)
verifier.load_key(pubkey)
# normally the message digest is recalculated
good = verifier.verify(digest, signature)
if good:
    print '  verifies  *** good ***'
else:
    print '  verifies  *** bad ***'

#---------------------------------------------------------------
#---------------------------------------------------------------
#---------------------------------------------------------------

