#!/usr/bin/env python

"""
    demo-cipher1.py
    
    This program is an elementary demonstration of various 
    algorithms implemented in TomLibCrypt. 
    
    pyTomCrypt is experimental software and intended for 
    educational purposes only.  To make your learning and 
    experimentation less cumbersome, pyTomCrypt is placed 
    in the Public Domain.
    
    Enjoy,
      
    Larry Bugbee
    bugbee@seanet.com
    March 6, 2007

"""


from pyTomCrypt import *

#---------------------------------------------------------------
# utility function
def byt2hex(bs):
    "convert a byte string to hex"
    h = ''
    for c in bs:
        h += ('0'+hex(ord(c))[2:])[-2:]
    return h

#---------------------------------------------------------------
# list supported symmetric ciphers
supported = get_supported_ciphers()
print '  Supported cipher algorithms:'
for alg in supported:
    print '    %s' % alg
print

#---------------------------------------------------------------
# list supported modes
supported = get_supported_modes()
print '  Supported modes:'
for alg in supported:
    print '    %s' % alg
print

#---------------------------------------------------------------
# encrypt and decrypt using AES in CBC mode

orig_message = 'Kilroy was here! ...and there.'
alg  = 'aes'
mode = 'cbc'
key  = 'hello'

ctx = Cipher_Context(alg, mode, key)
IV = ctx.getiv()        # conveniently get a rendom number
                        # or provide your own

# encrypting the last block...
padded_message = pad(orig_message, ctx._blocksize)
encrypted_msg = ctx.encrypt(padded_message)

#decrypting
ctx2 = Cipher_Context(alg, mode, key, IV)
decrypted_text = ctx2.decrypt(encrypted_msg)
# the last block...
decrypted_msg = unpad(decrypted_text)

print '  orig_message   ', orig_message
print '  algorithm      ', alg
print '  mode           ', mode
print '  key            ', key
print '  IV             ', byt2hex(IV)
print '  encrypted_msg  ', byt2hex(encrypted_msg)
print '  decrypted_msg  ', decrypted_msg
if decrypted_msg == orig_message:
    print '  decryption  *** good ***'
else:
    print '  decryption  *** bad ***'
print

#---------------------------------------------------------------
# encrypt and decrypt using Twofish in CTR mode

orig_message = 'Kilroy was here! ...and there.'
alg  = 'twofish'
mode = 'ctr'
key  = 'goodbye'

ctx = Cipher_Context(alg, mode, key)
IV = ctx.getiv()

# encrypting...  ctr mode does not need padding
encrypted_msg = ctx.encrypt(orig_message)

#decrypting
ctx2 = Cipher_Context(alg, mode, key, IV)
decrypted_msg = ctx2.decrypt(encrypted_msg)

print '  orig_message   ', orig_message
print '  algorithm      ', alg
print '  mode           ', mode
print '  key            ', key
print '  IV             ', byt2hex(IV)
print '  encrypted_msg  ', byt2hex(encrypted_msg)
print '  decrypted_msg  ', decrypted_msg
if decrypted_msg == orig_message:
    print '  decryption  *** good ***'
else:
    print '  decryption  *** bad ***'
print

#---------------------------------------------------------------
#---------------------------------------------------------------
#---------------------------------------------------------------

